/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.integrator;

import filenet.vw.api.VWException;
import filenet.vw.apps.taskman.VWTaskActionCommand;
import filenet.vw.apps.taskman.VWTaskNumericProperty;
import filenet.vw.apps.taskman.VWTaskPropertyChangedEvent;
import filenet.vw.apps.taskman.VWTaskPropertyPanel;
import filenet.vw.apps.taskman.VWTaskTabPanel;
import filenet.vw.apps.taskman.VWTaskTabbedPane;
import filenet.vw.apps.taskman.integrator.VWAdaptorNode;
import filenet.vw.apps.taskman.integrator.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWXMLWrapper;
import filenet.vw.server.VWCapsule;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.w3c.dom.Node;

public class VWAdaptorPropertyPanel
extends VWTaskPropertyPanel {
    VWAdaptorNode m_node = null;
    VWTaskTabbedPane m_tabbedPane = null;
    VWXMLWrapper m_xmlWrapper = null;
    String m_encryptedPassword = null;
    JLabel m_iconLabel = null;
    JTextField m_avgCallsPerMin = null;
    JTextField m_avgCallTime = null;
    JTextField m_userName = null;
    JPasswordField m_password = null;
    JTextField m_configContext = null;
    JTextField m_name = null;
    JTextField m_type = null;
    JTextField m_exceptionMap = null;
    JTextArea m_description = null;
    JTextArea m_status = null;
    VWTaskNumericProperty m_threadCount = null;
    VWTaskNumericProperty m_pollingRate = null;
    VWTaskNumericProperty m_maxPollingRate = null;
    boolean m_isWSAdaptor = false;
    protected static final boolean REQUIRED = true;
    protected static final boolean NOT_REQUIRED = false;

    public VWAdaptorPropertyPanel(VWAdaptorNode adaptorNode, String serviceDescriptor) {
        this.setDoubleBuffered(true);
        this.setLayout(new BorderLayout());
        this.m_node = adaptorNode;
        try {
            this.m_xmlWrapper = new VWXMLWrapper(serviceDescriptor);
            String adaptor_class = VWXMLWrapper.getNodeValue(this.m_xmlWrapper.getRootNode(), "adaptor_class");
            this.m_isWSAdaptor = adaptor_class != null && adaptor_class.indexOf("VWWebServicesAdaptor") != -1;
            this.addTabbedPane();
            this.resetProperties();
            this.refresh();
        }
        catch (Exception e) {
            this.m_node.displayError(e);
        }
        this.m_tabbedPane.addVWTaskPropertyChangedListener(this);
    }

    public void refresh() {
        this.refresh(null);
    }

    public String getAdaptorType() {
        if (this.m_type != null) {
            return this.m_type.getText().trim();
        }
        return null;
    }

    public void refresh(String serviceDescriptor) {
        try {
            if (serviceDescriptor != null) {
                this.m_xmlWrapper = new VWXMLWrapper(serviceDescriptor);
                this.resetProperties();
            }
            boolean stopped = !this.m_node.isStarted();
            this.m_userName.setEditable(stopped);
            this.m_password.setEditable(stopped);
            this.m_configContext.setEditable(stopped);
            this.m_exceptionMap.setEditable(stopped);
            this.m_threadCount.setEditable(stopped);
            this.m_pollingRate.setEditable(stopped);
            if (this.m_isWSAdaptor) {
                this.m_maxPollingRate.setEditable(stopped);
            }
            this.m_description.setEditable(stopped);
            this.m_iconLabel.setIcon(this.m_node.getIcon32());
        }
        catch (Exception e) {
            this.m_node.displayError(e);
        }
    }

    public void setAvgCallsMinute(long avgCallsPerMinute) {
        this.m_avgCallsPerMin.setText(Long.toString(avgCallsPerMinute));
    }

    public void setAvgCallTime(long avgCallTime) {
        this.m_avgCallTime.setText(Long.toString(avgCallTime));
    }

    protected void setAdaptorStatus(String s) {
        if (s == null) {
            this.m_status.setText("");
        } else {
            this.m_status.setText(s);
        }
    }

    protected void addTabbedPane() {
        this.m_tabbedPane = new VWTaskTabbedPane();
        this.addGeneralTab();
        this.addAdvancedTab();
        this.add((Component)this.m_tabbedPane, "Center");
    }

    protected void addGeneralTab() {
        VWTaskTabPanel mainPanel = new VWTaskTabPanel();
        mainPanel.setHelpPage(VWHelp.Help_Process_TaskManager + "cm_comp_config_general.htm");
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbConst = new GridBagConstraints();
        gbConst.fill = 0;
        gbConst.anchor = 23;
        gbConst.gridwidth = 1;
        gbConst.gridheight = 1;
        gbConst.weightx = 0.0;
        gbConst.weighty = 0.0;
        gbConst.insets = new Insets(4, 10, 0, 0);
        gbConst.gridx = 0;
        gbConst.gridy = 0;
        this.m_iconLabel = new JLabel(this.m_node.getIcon32(), 2);
        mainPanel.add((Component)this.m_iconLabel, gbConst);
        gbConst.fill = 2;
        gbConst.weightx = 1.0;
        gbConst.gridy = 0;
        gbConst.gridx = 1;
        mainPanel.add((Component)this.createStatisticsPanel(), gbConst);
        VWTaskTabPanel panel = new VWTaskTabPanel();
        panel.setLayout(new GridBagLayout());
        this.m_name = new JTextField("");
        this.m_name.setEditable(false);
        this.m_name.addFocusListener(this);
        this.m_name.setName(filenet.vw.apps.taskman.resources.VWResource.Name);
        JLabel sNameLabel = new JLabel(this.m_name.getName() + ":");
        panel.add((Component)sNameLabel, LABEL_CONSTRAINTS);
        panel.add((Component)this.m_name, FIELD_CONSTRAINTS);
        this.m_type = new JTextField("");
        this.m_type.setEditable(false);
        this.m_type.addFocusListener(this);
        this.m_type.setName(filenet.vw.apps.taskman.resources.VWResource.Type);
        JLabel sTypeLabel = new JLabel(this.m_type.getName() + ":");
        panel.add((Component)sTypeLabel, LABEL_CONSTRAINTS);
        panel.add((Component)this.m_type, FIELD_CONSTRAINTS);
        Color bgColor = this.getBackground();
        this.m_description = new JTextArea();
        this.m_description.setRows(3);
        this.m_description.setEditable(false);
        this.m_description.addFocusListener(this);
        this.m_description.setBackground(bgColor);
        this.m_description.setWrapStyleWord(true);
        this.m_description.setName(VWResource.Description);
        JLabel sDescriptionLabel = new JLabel(this.m_description.getName() + ":");
        panel.add((Component)sDescriptionLabel, FIELD_CONSTRAINTS);
        panel.add((Component)new JScrollPane(this.m_description), FIELD_CONSTRAINTS);
        VWAccessibilityHelper.setAccessibility(sDescriptionLabel, this, sDescriptionLabel.getText(), sDescriptionLabel.getText());
        VWAccessibilityHelper.setAccessibility(this.m_description, this, this.m_description.getText(), this.m_description.getText());
        VWAccessibilityHelper.setLabelFor(sDescriptionLabel, this.m_description);
        this.m_status = new JTextArea();
        this.m_status.setEditable(false);
        this.m_status.setRows(6);
        this.m_status.setLineWrap(true);
        this.m_status.setWrapStyleWord(true);
        this.m_status.addFocusListener(this);
        this.m_status.setBackground(bgColor);
        this.m_status.setName(VWResource.Status);
        JLabel sStatusLabel = new JLabel(this.m_status.getName() + ":");
        panel.add((Component)sStatusLabel, FIELD_CONSTRAINTS);
        panel.add((Component)new JScrollPane(this.m_status), FIELD_CONSTRAINTS);
        VWAccessibilityHelper.setAccessibility(sStatusLabel, this, sStatusLabel.getText(), sStatusLabel.getText());
        VWAccessibilityHelper.setAccessibility(this.m_status, this, this.m_status.getText(), this.m_status.getText());
        VWAccessibilityHelper.setLabelFor(sStatusLabel, this.m_status);
        panel.add(Box.createVerticalStrut(20), FIELD_CONSTRAINTS);
        gbConst.gridy = 1;
        gbConst.gridx = 0;
        gbConst.fill = 1;
        gbConst.gridwidth = 0;
        gbConst.weightx = 1.0;
        gbConst.weighty = 1.0;
        mainPanel.add((Component)panel, gbConst);
        this.m_tabbedPane.addTab(filenet.vw.apps.taskman.resources.VWResource.General, mainPanel);
    }

    protected void addAdvancedTab() {
        VWTaskTabPanel panel = new VWTaskTabPanel();
        panel.setHelpPage(VWHelp.Help_Process_TaskManager + "cm_comp_config_advanced.htm");
        panel.setLayout(new GridBagLayout());
        this.m_userName = new JTextField("");
        this.m_userName.addFocusListener(this);
        this.m_userName.setName(VWResource.UserName);
        JLabel sUserNameLabel = new JLabel(this.m_userName.getName() + ":");
        if (!this.m_isWSAdaptor) {
            panel.add((Component)sUserNameLabel, LABEL_CONSTRAINTS);
            panel.add((JTextComponent)this.m_userName, (Object)FIELD_CONSTRAINTS, true);
        }
        this.m_password = new JPasswordField("");
        this.m_password.addFocusListener(this);
        this.m_password.setName(VWResource.Password);
        if (!this.m_isWSAdaptor) {
            panel.add((Component)new JLabel(this.m_password.getName() + ":"), LABEL_CONSTRAINTS);
            panel.add((JTextComponent)this.m_password, (Object)FIELD_CONSTRAINTS, false);
        }
        this.m_configContext = new JTextField("");
        this.m_configContext.addFocusListener(this);
        this.m_configContext.setName(VWResource.ConfigurationContext);
        if (!this.m_isWSAdaptor) {
            panel.add((Component)new JLabel(this.m_configContext.getName() + ":"), LABEL_CONSTRAINTS);
            panel.add((JTextComponent)this.m_configContext, (Object)FIELD_CONSTRAINTS, true);
        }
        this.m_threadCount = new VWTaskNumericProperty("");
        this.m_threadCount.addFocusListener(this);
        this.m_threadCount.setName(VWResource.ConcurrentThreads);
        panel.add((Component)new JLabel(this.m_threadCount.getName() + ":"), LABEL_CONSTRAINTS);
        panel.add((JTextComponent)this.m_threadCount, (Object)FIELD_CONSTRAINTS, true);
        this.m_pollingRate = new VWTaskNumericProperty("");
        this.m_pollingRate.addFocusListener(this);
        if (this.m_isWSAdaptor) {
            this.m_pollingRate.setName(VWResource.MinPollingInterval);
        } else {
            this.m_pollingRate.setName(VWResource.PollingRate);
        }
        panel.add((Component)new JLabel(this.m_pollingRate.getName() + ":"), LABEL_CONSTRAINTS);
        panel.add((JTextComponent)this.m_pollingRate, (Object)FIELD_CONSTRAINTS, true);
        if (this.m_isWSAdaptor) {
            this.m_maxPollingRate = new VWTaskNumericProperty("");
            this.m_maxPollingRate.addFocusListener(this);
            this.m_maxPollingRate.setName(VWResource.MaxPollingInterval);
            panel.add((Component)new JLabel(this.m_maxPollingRate.getName() + ":"), LABEL_CONSTRAINTS);
            panel.add((JTextComponent)this.m_maxPollingRate, (Object)FIELD_CONSTRAINTS, true);
        }
        this.m_exceptionMap = new JTextField("");
        this.m_exceptionMap.addFocusListener(this);
        this.m_exceptionMap.setName(VWResource.ExceptionSubmap);
        if (!this.m_isWSAdaptor) {
            panel.add((Component)new JLabel(this.m_exceptionMap.getName() + ":"), LABEL_CONSTRAINTS);
            panel.add((JTextComponent)this.m_exceptionMap, (Object)FIELD_CONSTRAINTS, true);
        }
        this.m_tabbedPane.addTab(filenet.vw.apps.taskman.resources.VWResource.Advanced, panel);
    }

    protected JPanel createStatisticsPanel() {
        JPanel panel = null;
        try {
            panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            GridBagConstraints gbConst = new GridBagConstraints();
            gbConst.fill = 0;
            gbConst.anchor = 23;
            gbConst.gridwidth = 1;
            gbConst.gridheight = 1;
            gbConst.weightx = 0.0;
            gbConst.weighty = 0.0;
            gbConst.insets = new Insets(4, 10, 0, 0);
            gbConst.gridx = 0;
            gbConst.gridy = 0;
            JLabel sAverageCallsPerMinute = new JLabel(VWResource.AverageCallsMinute + ":");
            panel.add((Component)sAverageCallsPerMinute, gbConst);
            this.m_avgCallsPerMin = new JTextField("0.0");
            this.m_avgCallsPerMin.setEditable(false);
            this.m_avgCallsPerMin.setName(sAverageCallsPerMinute.getText());
            this.m_avgCallsPerMin.addFocusListener(this);
            gbConst.gridx = 1;
            panel.add((Component)this.m_avgCallsPerMin, gbConst);
            JLabel sAverageCallTimePerSecond = new JLabel(VWResource.AverageCallTime + ":");
            gbConst.gridx = 2;
            gbConst.insets = new Insets(4, 40, 0, 0);
            panel.add((Component)sAverageCallTimePerSecond, gbConst);
            this.m_avgCallTime = new JTextField("0.0");
            this.m_avgCallTime.setEditable(false);
            this.m_avgCallTime.setName(sAverageCallTimePerSecond.getText());
            this.m_avgCallTime.addFocusListener(this);
            gbConst.gridx = 3;
            gbConst.weightx = 1.0;
            gbConst.insets = new Insets(4, 10, 0, 0);
            panel.add((Component)this.m_avgCallTime, gbConst);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        panel.getAccessibleContext().setAccessibleParent(this);
        return panel;
    }

    public void actionPerformed(ActionEvent event) {
        String actionCMD = event.getActionCommand();
        Object aObj = event.getSource();
        try {
            if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.APPLY) == 0 || VWStringUtils.compare(actionCMD, VWTaskActionCommand.OK) == 0) {
                if (this.validateProperties()) {
                    this.applyProperties();
                }
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.RESET) == 0 || VWStringUtils.compare(actionCMD, VWTaskActionCommand.CANCEL) == 0) {
                this.resetProperties();
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.HELP) == 0) {
                this.m_tabbedPane.displayHelp();
            }
        }
        catch (Exception ex) {
            this.m_node.displayError(ex);
        }
    }

    public void applyProperties() throws Exception {
        if (this.m_xmlWrapper != null) {
            String password = new String(this.m_password.getPassword());
            if (!password.equals("*******")) {
                this.m_encryptedPassword = password.length() > 0 ? new VWCapsule(password).getStr() : "";
            }
            Node rootNode = this.m_xmlWrapper.getRootNode();
            if (!this.m_isWSAdaptor) {
                this.m_xmlWrapper.setNodeValue(rootNode, "jaas_username", this.m_userName.getText().trim());
                this.m_xmlWrapper.setNodeValue(rootNode, "jaas_password", this.m_encryptedPassword);
                this.m_xmlWrapper.setNodeValue(rootNode, "exception_submap", this.m_exceptionMap.getText().trim());
                this.m_xmlWrapper.setNodeValue(rootNode, "jaas_configcontext", this.m_configContext.getText().trim());
            } else {
                try {
                    long p1 = Long.parseLong(this.m_pollingRate.getText());
                    long p2 = Long.parseLong(this.m_maxPollingRate.getText());
                    if (p2 < p1) {
                        p2 = p1;
                        this.m_maxPollingRate.setText(Long.toString(p2));
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                this.m_xmlWrapper.setNodeValue(rootNode, "max_polling_rate", this.m_maxPollingRate.getText().trim());
            }
            this.m_xmlWrapper.setNodeValue(rootNode, "concurrent_threads", this.m_threadCount.getText().trim());
            this.m_xmlWrapper.setNodeValue(rootNode, "polling_rate", this.m_pollingRate.getText().trim());
            this.m_node.setComponentDescriptor(this.m_xmlWrapper.toString());
        }
        this.taskPropertyChanged(new VWTaskPropertyChangedEvent((Object)this, 1));
    }

    public void resetProperties() throws Exception {
        this.m_name.setText(this.m_node.getName());
        String value = VWXMLWrapper.getNodeValue(this.m_xmlWrapper.getRootNode(), "adaptor_name");
        if (value != null) {
            this.m_type.setText(value);
        }
        if ((value = VWXMLWrapper.getNodeValue(this.m_xmlWrapper.getRootNode(), "description")) != null) {
            this.m_description.setText(value);
        }
        if ((value = VWXMLWrapper.getNodeValue(this.m_xmlWrapper.getRootNode(), "jaas_username")) != null) {
            this.m_userName.setText(value);
        }
        if ((value = VWXMLWrapper.getNodeValue(this.m_xmlWrapper.getRootNode(), "jaas_password")) != null) {
            this.m_encryptedPassword = value;
            this.m_password.setText("*******");
        }
        if ((value = VWXMLWrapper.getNodeValue(this.m_xmlWrapper.getRootNode(), "jaas_configcontext")) != null) {
            this.m_configContext.setText(value);
        }
        if ((value = VWXMLWrapper.getNodeValue(this.m_xmlWrapper.getRootNode(), "concurrent_threads")) != null) {
            this.m_threadCount.setText(value);
        }
        if ((value = VWXMLWrapper.getNodeValue(this.m_xmlWrapper.getRootNode(), "polling_rate")) != null) {
            this.m_pollingRate.setText(value);
        }
        if (this.m_isWSAdaptor) {
            value = VWXMLWrapper.getNodeValue(this.m_xmlWrapper.getRootNode(), "max_polling_rate");
            if (value != null) {
                this.m_maxPollingRate.setText(value);
            }
        }
        if ((value = VWXMLWrapper.getNodeValue(this.m_xmlWrapper.getRootNode(), "exception_submap")) != null) {
            this.m_exceptionMap.setText(value);
        }
        this.taskPropertyChanged(new VWTaskPropertyChangedEvent((Object)this, 2));
    }

    protected boolean validateProperties() {
        try {
            this.m_tabbedPane.validateProperties();
        }
        catch (VWException e) {
            this.m_node.displayError(e);
            return false;
        }
        return true;
    }
}

